package w83b.w83bOperacionesPaso.w83bResultados;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaResulPorEscrutinioExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bResulPorEscrutinio.xls";
		InputStream inputStream = W83bTablaResulPorEscrutinioExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        Map diferencias = (HashMap)contexto.get("w83bMapResultadosBean");
        W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);
	   
        HSSFRow row;
        HSSFCell cell;
 
        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)5);
        
        StringBuffer tituloImagenEu =  (StringBuffer)datosDelDep.get("tituloDepEu");
        StringBuffer tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDepEs");
      
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7); 
        cell.setCellValue(tituloImagenEs.toString());
        
       
        tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDelelegacionEu");
        tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDelelegacionEs");
       
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)7); 
        cell.setCellValue(tituloImagenEs.toString());
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        row = sheet.getRow((short)9);     
        cell = row.getCell((short)0);    
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.resultadosEscrutinio").toUpperCase());    
        
        
        row = sheet.getRow((short)10); 
        cell = row.getCell((short)5); 
       
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
    	}	
        
        row = sheet.getRow((short)11); 
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.territorio"));
        cell = row.getCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getDescTerritorio())){
        	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(resultadoBean.getDescTerritorio()));
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.ONCE,excel,wb));
        
        cell = row.getCell((short)4);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.comunicaciones.numactadesde"));
        cell = row.createCell((short)5); 
        cell.setCellValue(resultadoBean.getTerritActaDesde()+"/"+resultadoBean.getAnoActaDesde()+"/"+resultadoBean.getNumActaDesde());
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.ONCE,excel,wb));
        
        cell = row.getCell((short)6);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.comunicaciones.numactahasta"));
        cell = row.createCell((short)8);
        if(StringUtils.isNotEmpty(resultadoBean.getAnoActaHasta())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.ONCE,Short.parseShort("8"),W83bClsConstantes.ONCE,Short.parseShort("10")));//NOPMD
        	cell.setCellValue(resultadoBean.getTerritActaHasta()+"/"+resultadoBean.getAnoActaHasta()+"/"+resultadoBean.getNumActaHasta());
        }else{
        	cell.setCellValue(resultadoBean.getTerritActaHasta()+"/"+resultadoBean.getAnoActaHasta()+"/"+resultadoBean.getNumActaHasta());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.ONCE,excel,wb));
        
        
        row = sheet.getRow((short)12); 
       
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.certificaciones.fechaEleccionDesde"));
        cell = row.getCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
        	cell.setCellValue(resultadoBean.getFechaEleccionDesde());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        
        cell = row.getCell((short)4);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.certificaciones.fechaEleccionHasta"));
        cell = row.createCell((short)5); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionHasta())){
        	cell.setCellValue(resultadoBean.getFechaEleccionHasta());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        cell = row.getCell((short)6);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.fechaRegDefinitivoHasta"));
        cell = row.createCell((short)8); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaRegistroDefinitivo())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("8"),W83bClsConstantes.DOCE,Short.parseShort("10")));//NOPMD
        	cell.setCellValue(resultadoBean.getFechaRegistroDefinitivo());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell((short)12);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.convenio"));
        cell = row.createCell((short)13); 
        if(StringUtils.isNotEmpty(resultadoBean.getConvenioTxt())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("13"),W83bClsConstantes.DOCE,Short.parseShort("15")));//NOPMD
        	cell.setCellValue(resultadoBean.getConvenioTxt().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        row = sheet.getRow((short)16); 
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nRegistro"));
        cell = row.getCell((short)2);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.comarca"));
        cell = row.getCell((short)4);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.municipio"));
        cell = row.getCell((short)5);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.convenio"));
        cell = row.getCell((short)6);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.cnae"));
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.nEntrada"));
        cell = row.getCell((short)8);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.admon"));
        cell = row.getCell((short)10);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.colegio"));
        cell = row.getCell((short)11);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.numElectores"));
        cell = row.getCell((short)12);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegados.numDelegados"));
        cell = row.getCell((short)13);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nVotos"));
        cell = row.getCell((short)14);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.delegSindicatoHist"));
        
        Map mapEscrutiniosOrdenado = new TreeMap(diferencias);
        Set ref = mapEscrutiniosOrdenado.keySet();
        
      
	  int lineaactual=17;
	  
	  Iterator it=ref.iterator();
	 String key="";
	 W83bResultadosBean datos;
       while(it.hasNext())
       {
    	  
    	   key=(String)it.next();
    	   datos=(W83bResultadosBean)mapEscrutiniosOrdenado.get(key);
    	  
     		row = sheet.createRow((short)lineaactual); 
     		 
     	
    	    	   row = sheet.createRow((short)lineaactual); 
    	    	   
	       	  		cell=row.createCell((short)1);	
	       	  		if(StringUtils.isNotEmpty(datos.getNregistro())){
	       	  			cell.setCellValue((String)datos.getNregistro());
	       	  		}
		       	  	cell.setCellStyle(estiloFila(lineaactual,excel));
	       	  	    cell=row.createCell((short)2);	
	       	  	    sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("2"),lineaactual,Short.parseShort("3")));//NOPMD
	       	  	    if(StringUtils.isNotEmpty(datos.getComarca())){
	       	  	    	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel((String)datos.getComarca()));
	       	  	    }
		       	  	cell.setCellStyle(estiloFila(lineaactual,excel));
		       	  	cell=row.createCell((short)3);	
		       	  	cell.setCellStyle(estiloFila(lineaactual,excel));
		       	  	cell=row.createCell((short)4);
		       	  	if(StringUtils.isNotEmpty(datos.getMunicipio())){
		       		 	cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel((String)datos.getMunicipio()));
		       	  	}
		       	  	cell.setCellStyle(estiloFila(lineaactual,excel));
	       	  		
		       	  	cell=row.createCell((short)5);
		       	  	if(W83bClsConstantes.CONSTANTE_EUSKARA.equals(idioma))
		       	  	{
		       	  		if(StringUtils.isNotEmpty(datos.getDeseconvenio())){
		       	  			cell.setCellValue((String)datos.getDeseconvenio());
		       	  		}
		       	  	}else{
		       	  		if(StringUtils.isNotEmpty(datos.getDescconvenio())){
		       	  			cell.setCellValue((String)datos.getDescconvenio());
		       	  		}
		       	  	}
		       	    
		       	    cell.setCellStyle(estiloFila(lineaactual,excel));
		       	  	cell=row.createCell((short)6);
		       	  	if(StringUtils.isNotEmpty(datos.getCodcnae())){
		       	  		cell.setCellValue(W83bUtilidades.numero(datos.getCodcnae()));
		       	  	}
		       	  	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
	       	  		
		       	  	cell=row.createCell((short)7);
		       	  	if(StringUtils.isNotEmpty(datos.getNacta())){
		       	  		cell.setCellValue((String)datos.getNacta());
		       	  	}
		       	  	cell.setCellStyle(estiloFila(lineaactual,excel));
	       	  		
		       	  	cell=row.createCell((short)8);
		       	  	if(StringUtils.isNotEmpty(datos.getAdminemp())){
		       	  		cell.setCellValue((String)datos.getAdminemp());
		       	  	}
		       	  	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
		       	  	
	       	  	    sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("9"),lineaactual,Short.parseShort("10")));//NOPMD
		       	  	cell=row.createCell((short)9);
		       	  	if(StringUtils.isNotEmpty(datos.getCodcolegio())){
		       	  		cell.setCellValue((String)datos.getCodcolegio());
		       	 	}
		       	  	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
		       	  	cell=row.createCell((short)10);
		       	 	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
	       	  		
		       	  	cell=row.createCell((short)11);
		       	  	if(StringUtils.isNotEmpty(datos.getNumTrabajadores())){
		       	  		cell.setCellValue(W83bUtilidades.numero(datos.getNumTrabajadores()));
		       	  	}
		       	  	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
		       	  	
		       	  	
		       	  	cell=row.createCell((short)12);
		       	  	if(StringUtils.isNotEmpty(datos.getNumdelegados())){
		       	  		cell.setCellValue(W83bUtilidades.numero(datos.getNumdelegados()));
		       	  	}
		       	  	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
		       	  	
		       		cell=row.createCell((short)13);
		       		if(StringUtils.isNotEmpty(datos.getVotos())){
		       			cell.setCellValue(W83bUtilidades.numero(datos.getVotos()));
		       		}
		       	  	cell.setCellStyle(estiloFilaCentrado(lineaactual,excel));
		       	  	
		       	  	sheet.addMergedRegion(new Region(lineaactual,Short.parseShort("14"),lineaactual,Short.parseShort("15")));//NOPMD
	       	  	  	cell=row.createCell((short)14);
	       	  	  	if(StringUtils.isNotEmpty(datos.getSindicatosDeleg())){
	       	  	  		cell.setCellValue((String)datos.getSindicatosDeleg());
	       	  	  	}
	       	  	  	cell.setCellStyle(estiloFila(lineaactual,excel));
		       	  	cell=row.createCell((short)15);
		       	 	cell.setCellStyle(estiloFila(lineaactual,excel));
	       	  	  	
	       	  	  
	       	  		lineaactual++;
        }
    	     
      
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=ResultadosPorEscrutinios.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	/**
	 * Estilo fila centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParCentrado;
		}else{
			return excel.styleTextoImparCentrado;			
		}
		
	}

	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}
